<?php

namespace App\Filament\Resources\WhatsappTemplateResource\Pages;

use App\Filament\Resources\WhatsappTemplateResource;
use Filament\Resources\Pages\ViewRecord;
use Filament\Forms\Form;
use Filament\Forms\Components\Textarea;
use Filament\Forms\Components\TextInput;
use Filament\Forms\Components\Fieldset;

class ViewWhatsappTemplate extends ViewRecord
{
    protected static string $resource = WhatsappTemplateResource::class;

    protected function getHeaderActions(): array
    {
        return [];
    }

    public function form(Form $form): Form
    {
        return $form->schema([
            Fieldset::make('تفاصيل القالب الأساسية')
                ->schema([
                    TextInput::make('name')
                        ->label('اسم القالب (API Name)')
                        ->disabled(),

                    TextInput::make('category')
                        ->label('الفئة')
                        ->disabled(),

                    TextInput::make('status')
                        ->label('الحالة')
                        ->disabled(),
                ])
                ->columns(2),

            Fieldset::make('مكونات القالب المهيكلة') // تغيير اسم Fieldset ليكون أوضح
                ->schema([
                    Textarea::make('components')
                        ->label('بيانات المكونات (JSON)')
                        ->rows(20)
                        ->columnSpanFull()
                        ->disabled()
                        // 🔑 تحويل القيمة إلى JSON مُنظم عند التهيئة
                        ->afterStateHydrated(function (Textarea $component, $state) {
                            if (is_array($state) || is_object($state)) {
                                $state = json_encode($state, JSON_PRETTY_PRINT | JSON_UNESCAPED_UNICODE);
                            } elseif (is_string($state)) {
                                $decoded = json_decode($state, true);
                                if (json_last_error() === JSON_ERROR_NONE) {
                                    $state = json_encode($decoded, JSON_PRETTY_PRINT | JSON_UNESCAPED_UNICODE);
                                }
                            }
                            $component->state($state);
                        })
                        // 🚀 تنسيق احترافي ومميز (خلفية داكنة، نص مميز، يدعم LTR)
                        ->extraAttributes([
                            'style' => '
                                background-color: #323232ff; /* لون داكن احترافي */
                              -webkit-text-fill-color: rgb(154 111 51) !important;
                              color:rgb(154 111 51) !important;
                                font-family: monospace;
                                overflow-x: auto;
                                padding: 1.5rem; /* زيادة البادينج */
                                border-radius: 8px;
                                text-align: left; /* يبدأ النص من اليسار لليمين (LTR) */
                                line-height: 1.6; /* تحسين قراءة الأسطر */
                                white-space: pre;
                                border: 1px solid #3e4a5d; /* إطار خفيف */
                                resize: none; /* منع تغيير حجمه يدويا */
                            ',
                            'dir' => 'ltr' // التأكيد على اتجاه النص من اليسار لليمين
                        ]),
                ]),
        ]);
    }
}