<?php

namespace App\Filament\Resources\CampaignResource\RelationManagers;

use Filament\Forms;
use Filament\Forms\Form;
use Filament\Resources\RelationManagers\RelationManager;
use Filament\Tables;
use Filament\Tables\Table;

class LogsRelationManager extends RelationManager
{
    protected static string $relationship = 'logs'; // اسم العلاقة في الموديل

    protected static ?string $title = 'سجل الإرسال'; // عنوان الجدول

    public function form(Form $form): Form
    {
        return $form
            ->schema([
                Forms\Components\TextInput::make('phone')
                    ->required()
                    ->maxLength(255),
            ]);
    }

    // لاحظ هنا: public function عادية (بدون static)
    public function table(Table $table): Table
    {
        return $table
            ->recordTitleAttribute('phone')
            ->columns([
                Tables\Columns\TextColumn::make('phone')
                    ->label('رقم الهاتف')
                    ->searchable(),
                    
                Tables\Columns\TextColumn::make('status')
                    ->label('الحالة')
                    ->badge()
                    ->color(fn (string $state): string => match ($state) {
                        'sent' => 'success',
                        'failed' => 'danger',
                        default => 'gray',
                    }),

                Tables\Columns\TextColumn::make('message_id')
                    ->label('Message ID')
                    ->copyable()
                    ->limit(20),

                Tables\Columns\TextColumn::make('created_at')
                    ->label('وقت الإرسال')
                    ->dateTime(),
            ])
            ->headerActions([
                // لا نحتاج لزر إنشاء
            ])
            ->actions([
                Tables\Actions\ViewAction::make()
                    ->label('تفاصيل الخطأ')
                    ->form([
                        Forms\Components\Textarea::make('error_reason')
                            ->label('سبب الفشل')
                            ->rows(5),
                    ])
                    ->visible(fn ($record) => $record->status === 'failed'),
            ]);
    }
}