<?php

namespace App\Filament\Resources\ContactResource\Pages;

use App\Filament\Resources\ContactResource;
use Filament\Actions;
use Filament\Resources\Pages\ListRecords;
use Filament\Forms\Components\FileUpload; // لرفع الملف
use Filament\Actions\Action; // الزر المخصص
use App\Imports\ContactsImport; // كلاس الاستيراد
use Maatwebsite\Excel\Facades\Excel; // واجهة المكتبة
use Filament\Notifications\Notification;

class ListContacts extends ListRecords
{
    protected static string $resource = ContactResource::class;

    protected function getHeaderActions(): array
    {
        return [
            // زر الاستيراد الجديد
            Action::make('importExcel')
                ->label('استيراد Excel')
                ->icon('heroicon-o-arrow-up-tray')
                ->color('success')
                ->form([
                    FileUpload::make('attachment')
                        ->label('اختر ملف Excel')
                        ->acceptedFileTypes([
                            'application/vnd.ms-excel', 
                            'application/vnd.openxmlformats-officedocument.spreadsheetml.sheet', 
                            'text/csv'
                        ])
                        ->required(),
                ])
                ->action(function (array $data) {
                    // تنفيذ عملية الاستيراد
                    Excel::import(new ContactsImport, $data['attachment']);

                    Notification::make()
                        ->title('تم استيراد جهات الاتصال بنجاح')
                        ->success()
                        ->send();
                }),

            Actions\CreateAction::make(),
        ];
    }
}