<?php

namespace App\Filament\Resources\WhatsAppAccountResource\Pages;

use App\Filament\Resources\WhatsAppAccountResource;
use Filament\Actions;
use Filament\Resources\Pages\ListRecords;
use Filament\Actions\Action;

class ListWhatsAppAccounts extends ListRecords
{
    protected static string $resource = WhatsAppAccountResource::class;

    protected function getHeaderActions(): array
    {
        return [
            // 1. زر الربط التلقائي (الجديد)
            Action::make('connect_facebook')
                ->label('ربط عبر فيسبوك (Facebook Login)')
                ->icon('heroicon-o-link')
                ->color('info') // لون أزرق مميز
                ->url(route('whatsapp.connect')), // تأكد أنك أضفت الروت كما شرحنا سابقاً

            // 2. زر الإنشاء اليدوي (القديم) - تمت إعادته هنا
            Actions\CreateAction::make()
                ->label('إضافة يدوية (Token)')
                ->icon('heroicon-o-plus'),
        ];
    }
}