<?php

namespace App\Filament\Widgets;

use App\Models\Contact;
use App\Models\CampaignLog;
use Filament\Widgets\StatsOverviewWidget as BaseWidget;
use Filament\Widgets\StatsOverviewWidget\Stat;
use Illuminate\Support\Facades\Auth;

class StatsOverview extends BaseWidget
{
    // تحديث البيانات كل 15 ثانية
    protected static ?string $pollingInterval = '15s';

    // ترتيب الظهور (في الأعلى)
    protected static ?int $sort = 1;

    protected function getStats(): array
    {
        $user = Auth::user();

        // 1. عدد جهات الاتصال
        $totalContacts = Contact::where('user_id', $user->id)->count();

        // 2. الرسائل الناجحة
        $totalSent = CampaignLog::whereHas('campaign', function ($q) use ($user) {
            $q->where('user_id', $user->id);
        })->where('status', 'sent')->count();

        // 3. الرسائل الفاشلة
        $totalFailed = CampaignLog::whereHas('campaign', function ($q) use ($user) {
            $q->where('user_id', $user->id);
        })->where('status', 'failed')->count();

        return [
            Stat::make('جهات الاتصال', $totalContacts)
                ->description('الجمهور المستهدف')
                ->descriptionIcon('heroicon-m-users')
                ->color('primary'),

            Stat::make('الرسائل الناجحة', $totalSent)
                ->description('تم تسليمها بنجاح')
                ->descriptionIcon('heroicon-m-check-badge')
                ->color('success')
                ->chart([7, 2, 10, 3, 15, 4, 17]),

            Stat::make('فشل الإرسال', $totalFailed)
                ->description('رسائل لم تصل')
                ->descriptionIcon('heroicon-m-x-circle')
                ->color('danger'),
        ];
    }
}