<?php

namespace App\Http\Controllers;

use Illuminate\Http\Request;
use Illuminate\Support\Facades\Http;
use App\Models\WhatsAppAccount;
use Illuminate\Support\Facades\Auth;

class WhatsAppAuthController extends Controller
{
    // ضع هذه القيم في ملف .env
    protected $appId;      // FACEBOOK_CLIENT_ID
    protected $appSecret;  // FACEBOOK_CLIENT_SECRET
    
    public function __construct()
    {
        $this->appId = env('FACEBOOK_CLIENT_ID');
        $this->appSecret = env('FACEBOOK_CLIENT_SECRET');
    }

    /**
     * 1. توجيه المستخدم لفيسبوك
     */
    public function connect()
    {
        $redirectUrl = route('whatsapp.callback');
        
        // الصلاحيات المطلوبة للـ Embedded Signup
        $scope = 'whatsapp_business_management,whatsapp_business_messaging';
        
        // إعداد رابط تسجيل الدخول المدمج
        $url = "https://www.facebook.com/v18.0/dialog/oauth?client_id={$this->appId}&redirect_uri={$redirectUrl}&scope={$scope}&response_type=code&extras={\"setup\":{\"type\":\"WA_signup\"}}";

        return redirect($url);
    }

    /**
     * 2. استقبال المستخدم بعد الموافقة
     */
    public function callback(Request $request)
    {
        if ($request->has('error')) {
            return redirect('/admin/whatsapp-accounts')->with('error', 'تم إلغاء العملية');
        }

        $code = $request->code;
        $redirectUrl = route('whatsapp.callback');

        // أ) استبدال الكود بـ Access Token
        $tokenResponse = Http::get("https://graph.facebook.com/v18.0/oauth/access_token", [
            'client_id' => $this->appId,
            'client_secret' => $this->appSecret,
            'redirect_uri' => $redirectUrl,
            'code' => $code
        ]);

        if (!$tokenResponse->successful()) {
            return "Error getting token: " . $tokenResponse->body();
        }

        $accessToken = $tokenResponse->json()['access_token'];

        // ب) جلب معلومات الـ Business والأرقام المربوطة
        // هذه الخطوة تتطلب قراءة التوكن ومعرفة ما بداخله
        // ملاحظة: في الـ Embedded Signup، فيسبوك يرجع قائمة الأرقام التي سجلها العميل
        
        // سنفترض هنا أننا سنجلب WABA ID والأرقام
        // هذه الخطوة تحتاج دقة وتعتمد على رد فيسبوك (Debug Token)
        $debug = Http::get("https://graph.facebook.com/debug_token", [
            'input_token' => $accessToken,
            'access_token' => $accessToken // أو App Access Token
        ])->json();
        
        // *ملاحظة:* للحصول على الأرقام بدقة، نستخدم الـ Shared WABA ID الذي يرجعه الـ Setup
        // للتبسيط في هذا الكود، سنقوم بتخزين التوكن ونطلب من المستخدم اختيار الرقم لاحقاً
        // أو نقوم بجلب الأرقام تلقائياً:
        
        $wabaId = $this->getWabaIdFromToken($accessToken); // دالة مساعدة
        $phones = $this->getPhoneNumbers($wabaId, $accessToken); // دالة مساعدة

        foreach ($phones as $phone) {
            WhatsAppAccount::updateOrCreate(
                [
                    'phone_number_id' => $phone['id'],
                ],
                [
                    'user_id' => Auth::id(),
                    'name' => $phone['verified_name'] ?? $phone['display_phone_number'],
                    'waba_id' => $wabaId,
                    'access_token' => $accessToken, // هذا التوكن يعمل لهذا الرقم
                ]
            );
        }

        return redirect('/admin/whatsapp-accounts')->with('success', 'تم ربط الحساب بنجاح!');
    }

    // دوال مساعدة لجلب البيانات من API
    protected function getWabaIdFromToken($token)
    {
        // عادة نستخدم نقطة نهاية `me/accounts` أو نفحص `granularity`
        // للتبسيط، سنأخذ أول حساب أعمال يجده
        $response = Http::withToken($token)->get("https://graph.facebook.com/v18.0/me?fields=id,name,accounts");
        // هنا يجب تحليل الرد بدقة حسب هيكلية حساب العميل
        // سنفترض وجود ID
        return $response->json()['id'] ?? null; 
    }

    protected function getPhoneNumbers($wabaId, $token)
    {
        // جلب أرقام الهواتف المرتبطة بـ WABA
        // ملاحظة: إذا لم يكن لدينا WABA ID دقيق، نستخدم `me/phone_numbers` إذا سمح التوكن
        // الطريقة الأضمن في Embedded Signup هي استخدام setup object
        
        // كود تقريبي للتوضيح:
        $response = Http::withToken($token)->get("https://graph.facebook.com/v18.0/{$wabaId}/phone_numbers");
        return $response->json()['data'] ?? [];
    }
}