<?php

namespace App\Imports;

use App\Models\Contact;
use Maatwebsite\Excel\Concerns\ToModel;
use Maatwebsite\Excel\Concerns\WithHeadingRow; // لتجاهل الصف الأول (العناوين)
use Illuminate\Support\Facades\Auth;

class ContactsImport implements ToModel, WithHeadingRow
{
    /**
    * @param array $row
    *
    * @return \Illuminate\Database\Eloquent\Model|null
    */
    public function model(array $row)
    {
        // التأكد من وجود رقم هاتف في الصف
        if (!isset($row['phone']) || empty($row['phone'])) {
            return null;
        }

        // استخدام updateOrCreate لتجنب أخطاء التكرار
        return Contact::updateOrCreate(
            [
                // البحث بهذا الشرط (الرقم + المستخدم الحالي)
                'user_id' => Auth::id(), 
                'phone'   => $row['phone'],
            ],
            [
                // تحديث هذه البيانات
                'name' => $row['name'] ?? null,
            ]
        );
    }
}