<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class LandingPageSetting extends Model
{
    use HasFactory;

    // بما أنه جدول إعدادات مفرد، نمنع الـ Mass Assignment
    protected $guarded = [];

    // تحديد الحقول التي تخزن بيانات JSON
    protected $casts = [
        'main_features' => 'array',
        'testimonials' => 'array',
        'faq' => 'array',
    ];

    /**
     * جلب إعدادات صفحة الهبوط (سجل مفرد)
     * 🔑 يضمن إنشاء سجل بالقيم الافتراضية إذا لم يكن موجوداً
     * @return LandingPageSetting
     */
    public static function getSettings()
    {
        // 🔑 الحل: توفير قيم افتراضية للحقول الإلزامية (التي هي NOT NULL)
        $defaultSettings = [
            'hero_title_ar' => 'أطلق حملاتك عبر واتساب بسهولة',
            'hero_subtitle_ar' => 'نظام متكامل لإدارة حملات الرسائل الجماعية والردود التلقائية بكفاءة عالية.',
            'hero_cta_text_ar' => 'ابدأ تجربتك المجانية',
            'main_features' => [
                ['title_ar' => 'إرسال جماعي سريع', 'description_ar' => 'أرسل آلاف الرسائل دفعة واحدة.', 'icon' => 'heroicon-o-arrow-path'],
                ['title_ar' => 'تخصيص كامل للقوالب', 'description_ar' => 'استخدم القوالب المعتمدة لتخصيص محتوى الرسائل.', 'icon' => 'heroicon-o-envelope'],
                ['title_ar' => 'تتبع دقيق للحملات', 'description_ar' => 'راقب حالة التسليم والقراءة لكل حملة.', 'icon' => 'heroicon-o-chart-bar'],
            ],
            'faq' => [
                ['question_ar' => 'هل يحتاج النظام إلى اشتراك رسمي؟', 'answer_ar' => 'نعم، النظام يتطلب حساب واتساب للأعمال (WABA) لتجنب الحظر وضمان الإرسال الآمن.'],
                ['question_ar' => 'ماذا يحدث إذا نفد الرصيد الشهري؟', 'answer_ar' => 'يمكنك شراء رصيد إضافي في أي وقت من خلال لوحة التحكم.'],
            ]
        ];

        // إرجاع أول سجل أو إنشاء سجل جديد بالقيم الافتراضية المحددة (في الـ second array)
        return self::firstOrCreate([], $defaultSettings); 
    }
}