<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class Package extends Model
{
    use HasFactory;

    // 1. السماح بتعبئة جميع الحقول
    protected $fillable = [
        // المعلومات الأساسية
        'name',
        'slug',
        'description',
        'price',
        'duration_days',
        'is_visible',
        'is_popular',
        'sort_order',

        // الحدود (Quotas)
        'limit_messages',
        'limit_contacts',
        'limit_campaigns',
        'limit_wa_accounts',
        'limit_team_members',
        'limit_storage_mb',

        // الميزات (Features)
        'has_api_access',
        'has_chatbot',
        'has_media_upload',
        'has_schedule_campaigns',
        'has_excel_export',
        'has_priority_support',
        'remove_branding',
    ];

    // 2. تحويل البيانات تلقائياً (Casting)
    // هذا يضمن أن لارافيل يفهم أن 1 و 0 في قاعدة البيانات هي True و False في الكود
    protected $casts = [
        'is_visible' => 'boolean',
        'is_popular' => 'boolean',
        'has_api_access' => 'boolean',
        'has_chatbot' => 'boolean',
        'has_media_upload' => 'boolean',
        'has_schedule_campaigns' => 'boolean',
        'has_excel_export' => 'boolean',
        'has_priority_support' => 'boolean',
        'remove_branding' => 'boolean',
        
        // ضمان أن الأرقام تعود كأرقام صحيحة أو عشرية
        'price' => 'decimal:2',
        'limit_messages' => 'integer',
        'limit_contacts' => 'integer',
    ];
}