<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;
use Filament\Models\Contracts\FilamentUser; // تأكد من الـ imports

class WhatsAppAccount extends Model
{
    use HasFactory;

    //  <--- أضف هذا السطر لحل المشكلة
    protected $table = 'whatsapp_accounts'; 

    protected $fillable = [
        'user_id',
        'name',
        'phone_number_id',
        'waba_id',
        'access_token',
        'is_active',
        'webhook_last_check_at'.
        'webhook_status'
    ];

    protected $casts = [
        'access_token' => 'encrypted', 
        'is_active' => 'boolean',
        'webhook_last_check_at'=>'datetime'
    ];

    public function user()
    {
        return $this->belongsTo(User::class);
    }
}