<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\Relations\BelongsTo;

class WhatsappTemplate extends Model
{
    use HasFactory;
    
    // 1. تحديد الجدول (للتأكد فقط)
    protected $table = 'whatsapp_templates';

    // 2. السماح بتعبئة الحقول
    protected $fillable = [
        'whatsapp_account_id', // مفتاح خارجي لربط القالب بحساب الواتساب
        'name',
        'language',
        'status', // مثل APPROVED, REJECTED, PENDING
        'category', // مثل MARKETING, UTILITY
        'components', // لتخزين هيكل القالب كاملاً
    ];
    
    // 3. تحويل البيانات (Casting)
    protected $casts = [
        // نحول حقل 'components' إلى مصفوفة (Array) لتخزين الـ JSON الوارد من Meta
        'components' => 'array', 
    ];

    // 4. علاقة: القالب ينتمي إلى حساب واتساب واحد
    public function whatsappAccount(): BelongsTo
    {
        return $this->belongsTo(WhatsappAccount::class, 'whatsapp_account_id');
    }
}