<?php

namespace App\Providers\Filament;

use App\Settings\GeneralSettings; // استدعاء ملف الإعدادات
use Filament\Http\Middleware\Authenticate;
use Filament\Http\Middleware\DisableBladeIconComponents;
use Filament\Http\Middleware\DispatchServingFilamentEvent;
use Filament\Pages;
use Filament\Panel;
use Filament\PanelProvider;
use Filament\Support\Colors\Color;
use Filament\Widgets;
use Illuminate\Cookie\Middleware\AddQueuedCookiesToResponse;
use Illuminate\Cookie\Middleware\EncryptCookies;
use Illuminate\Foundation\Http\Middleware\VerifyCsrfToken;
use Illuminate\Routing\Middleware\SubstituteBindings;
use Illuminate\Session\Middleware\AuthenticateSession;
use Illuminate\Session\Middleware\StartSession;
use Illuminate\View\Middleware\ShareErrorsFromSession;
use App\Http\Middleware\SetLocale;

// استدعاء الصفحات الإضافية التي أنشأناها يدوياً
use App\Filament\Pages\ManageGeneralSettings;
use App\Filament\Pages\DeveloperApi;

class AdminPanelProvider extends PanelProvider
{
    public function panel(Panel $panel): Panel
    {
        // جلب الإعدادات المحفوظة في قاعدة البيانات
        // نستخدم try-catch لتجنب الأخطاء في حال لم يتم تشغيل المايكريشن بعد
        try {
            $settings = app(GeneralSettings::class);
        } catch (\Exception $e) {
            $settings = null;
        }

        return $panel
            ->default()
            ->id('admin')
            ->path('admin')
            ->login()

            // ---------------------------------------------------------
            // 1. الهوية البصرية الديناميكية (من قاعدة البيانات)
            // ---------------------------------------------------------
            ->brandName($settings->site_name ?? 'My SaaS Panel')
            ->brandLogo($settings && $settings->site_logo ? asset('storage/' . $settings->site_logo) : null)
            ->favicon($settings && $settings->site_logo ? asset('storage/' . $settings->site_logo) : null)
            
            // 2. الألوان (إذا حدد المستخدم لوناً، نستخدمه، وإلا فاللون الافتراضي Indigo)
            ->colors([
                'primary' => $settings->brand_color ?? Color::Indigo,
            ])
            
            // 3. الخط العربي والقائمة الجانبية
            ->font('Cairo')
            ->sidebarCollapsibleOnDesktop()
            
            // استكشاف الموارد والصفحات
            ->discoverResources(in: app_path('Filament/Resources'), for: 'App\\Filament\\Resources')
            ->discoverPages(in: app_path('Filament/Pages'), for: 'App\\Filament\\Pages')
            
            // ---------------------------------------------------------
            // 4. تسجيل الصفحات يدوياً لضمان ظهورها
            // ---------------------------------------------------------
            ->pages([
                Pages\Dashboard::class,       // الصفحة الرئيسية
                ManageGeneralSettings::class, // صفحة الإعدادات العامة
                DeveloperApi::class,          // صفحة بوابة المطورين
            ])
            
            ->discoverWidgets(in: app_path('Filament/Widgets'), for: 'App\\Filament\\Widgets')
            ->widgets([
                Widgets\AccountWidget::class,
            ])
            ->middleware([
                EncryptCookies::class,
                AddQueuedCookiesToResponse::class,
                StartSession::class,
                AuthenticateSession::class,
                ShareErrorsFromSession::class,
                VerifyCsrfToken::class,
                SubstituteBindings::class,
                DisableBladeIconComponents::class,
                DispatchServingFilamentEvent::class,
                SetLocale::class, // ميدلوير اللغة
            ])
            ->authMiddleware([
                Authenticate::class,
            ]);
    }
}