<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
         Schema::create('contacts', function (Blueprint $table) {
        $table->id();
        
        // ربط جهة الاتصال بالمستخدم (SaaS Isolation)
        $table->foreignId('user_id')->constrained()->cascadeOnDelete();
        
        $table->string('name')->nullable(); // اسم العميل
        $table->string('phone'); // رقم الهاتف
        
        // حقل مرن لتخزين بيانات إضافية مستقبلاً (مثل المدينة، العمر..)
        $table->json('data')->nullable(); 

        $table->timestamps();

        // قيد مركب: يمنع تكرار نفس الرقم لنفس المستخدم
        // لكن يسمح لمستخدمين مختلفين بإضافة نفس الرقم
        $table->unique(['user_id', 'phone']);
    });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('contacts');
    }
};
