<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
  public function up(): void
{
    Schema::create('campaigns', function (Blueprint $table) {
        $table->id();
        
        // ربط الحملة بالمستخدم (SaaS)
        $table->foreignId('user_id')->constrained()->cascadeOnDelete();
        
        // ربط الحملة بحساب واتساب الذي سيرسل الرسائل
        $table->foreignId('whatsapp_account_id')->constrained()->cascadeOnDelete();
        
        $table->string('name'); // اسم الحملة (للتنظيم الداخلي)
        
        // اسم القالب (Template Name) - ضروري في واتساب الرسمي
        $table->string('template_name')->default('hello_world'); 
        
        // لغة القالب
        $table->string('template_language')->default('en_US'); 

        // حالة الحملة: pending, processing, completed, failed
        $table->string('status')->default('pending');
        
        // عدد الرسائل الكلي والناجح والفاشل (للإحصائيات)
        $table->integer('total_contacts')->default(0);
        $table->integer('success_count')->default(0);
        $table->integer('failed_count')->default(0);

        $table->timestamps();
    });
}
    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('campaigns');
    }
};
