<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
{
    Schema::create('campaign_logs', function (Blueprint $table) {
        $table->id();
        
        // ربط السجل بالحملة (إذا حذفت الحملة تحذف سجلاتها)
        $table->foreignId('campaign_id')->constrained()->cascadeOnDelete();
        
        $table->string('phone'); // الرقم المستهدف
        $table->string('status'); // sent, failed
        $table->text('message_id')->nullable(); // معرف الرسالة من فيسبوك
        $table->text('error_reason')->nullable(); // سبب الفشل في حال وجوده

        $table->timestamps();
    });
}

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('campaign_logs');
    }
};
