<x-filament-panels::page>

    {{-- 1. قسم إدارة المفتاح --}}
    <div class="bg-white dark:bg-gray-900 rounded-xl shadow p-6 border border-gray-200 dark:border-gray-700">
        <h2 class="text-xl font-bold mb-4">مفتاح الربط (API Access Token)</h2>
        <p class="text-gray-500 mb-4 text-sm">استخدم هذا المفتاح للربط مع أنظمتك الخارجية. حافظ على سريته.</p>

        @if($token)
            <div class="bg-green-50 border border-green-200 text-green-800 p-4 rounded-lg mb-4 flex justify-between items-center" dir="ltr">
                <code class="font-mono font-bold text-lg break-all select-all">{{ $token }}</code>
                <span class="text-xs bg-green-200 px-2 py-1 rounded mx-2">New</span>
            </div>
            <p class="text-red-500 text-xs mb-4">⚠ انسخ هذا المفتاح الآن! سيختفي بمجرد تحديث الصفحة.</p>
        @else
            <div class="bg-gray-100 dark:bg-gray-800 p-4 rounded-lg mb-4 text-center">
                <p class="text-gray-500 tracking-widest">****************************************</p>
            </div>
        @endif

        <x-filament::button wire:click="generateToken" icon="heroicon-m-key" color="primary">
            توليد مفتاح API جديد
        </x-filament::button>
    </div>

    {{-- 2. قسم أمثلة الأكواد --}}
    <div class="mt-6" wire:ignore>
        <h3 class="text-lg font-bold mb-4">أمثلة الربط البرمجي (Integration Examples)</h3>
        <p class="text-sm text-gray-500 mb-4">يدعم النظام نوعين من الرسائل: نصية (Text) وقوالب (Template).</p>
        
        <div x-data="{ tab: 'curl_template' }" class="rounded-xl shadow border border-gray-200 dark:border-gray-700 overflow-hidden bg-gray-50 dark:bg-gray-800">
            
            {{-- أزرار التبويب --}}
            <div class="flex flex-wrap border-b border-gray-200 dark:border-gray-700">
                
                <button 
                    @click="tab = 'curl_template'" 
                    :class="tab === 'curl_template' ? 'bg-[#1e1e2e] !text-white border-t-4 border-blue-500' : 'bg-gray-100 text-gray-600 hover:bg-gray-200'"
                    class="px-4 py-3 text-sm font-bold transition flex-1 sm:flex-none"
                >
                    cURL (Template)
                </button>

                <button 
                    @click="tab = 'php_template'" 
                    :class="tab === 'php_template' ? 'bg-[#1e1e2e] !text-white border-t-4 border-blue-500' : 'bg-gray-100 text-gray-600 hover:bg-gray-200'"
                    class="px-4 py-3 text-sm font-bold transition flex-1 sm:flex-none"
                >
                    PHP (Template)
                </button>

                 <button 
                    @click="tab = 'curl_text'" 
                    :class="tab === 'curl_text' ? 'bg-[#1e1e2e] !text-white border-t-4 border-green-500' : 'bg-gray-100 text-gray-600 hover:bg-gray-200'"
                    class="px-4 py-3 text-sm font-bold transition flex-1 sm:flex-none"
                >
                    cURL (Text)
                </button>

            </div>

            {{-- صندوق الكود --}}
            <div style="background-color: #1e1e2e; color: #d4d4d4;" class="p-6 overflow-x-auto text-sm font-mono leading-relaxed" dir="ltr">
                
                {{-- Example 1: cURL Template (المصحح) --}}
                <div x-show="tab === 'curl_template'">
                    <div class="mb-2 text-gray-500">// Example: Sending OTP (Template with 1 variable)</div>
<pre>
<span style="color: #c586c0;">curl</span> -X POST <span style="color: #ce9178;">"{{ url('/api/v1/send-message') }}"</span> \
-H <span style="color: #ce9178;">"Authorization: Bearer <span style="color: #f1fa8c; font-weight: bold;">YOUR_API_KEY</span>"</span> \
-H <span style="color: #ce9178;">"Content-Type: application/json"</span> \
-d '{
    <span style="color: #9cdcfe;">"to"</span>: <span style="color: #ce9178;">"966500000000"</span>, <span style="color: #6a9955;">// رقم المستلم</span>
    <span style="color: #9cdcfe;">"template_name"</span>: <span style="color: #ce9178;">"otp_code"</span>,
    <span style="color: #9cdcfe;">"language_code"</span>: <span style="color: #ce9178;">"en"</span>,
    <span style="color: #9cdcfe;">"components"</span>: [
        {
            <span style="color: #9cdcfe;">"type"</span>: <span style="color: #ce9178;">"body"</span>,
            <span style="color: #9cdcfe;">"parameters"</span>: [
                {
                    <span style="color: #9cdcfe;">"type"</span>: <span style="color: #ce9178;">"text"</span>, 
                    <span style="color: #9cdcfe;">"text"</span>: <span style="color: #ce9178;">"59302"</span> <span style="color: #6a9955;">// قيمة المتغير الأول {{1}}</span>
                }
            ]
        }
    ]
}'
</pre>
                </div>

                {{-- Example 2: PHP Template (المصحح) --}}
                <div x-show="tab === 'php_template'">
                    <div class="mb-2 text-gray-500">// Example: Sending Order Update (Template with 2 variables)</div>
<pre>
<span style="color: #569cd6;">$client</span> = <span style="color: #c586c0;">new</span> \GuzzleHttp\Client();
<span style="color: #569cd6;">$response</span> = <span style="color: #569cd6;">$client</span>-><span style="color: #dcdcaa;">post</span>(<span style="color: #ce9178;">'{{ url('/api/v1/send-message') }}'</span>, [
    <span style="color: #ce9178;">'headers'</span> => [
        <span style="color: #ce9178;">'Authorization'</span> => <span style="color: #ce9178;">'Bearer <span style="color: #f1fa8c; font-weight: bold;">YOUR_API_KEY</span>'</span>,
        <span style="color: #ce9178;">'Accept'</span>        => <span style="color: #ce9178;">'application/json'</span>,
    ],
    <span style="color: #ce9178;">'json'</span> => [
        <span style="color: #ce9178;">'to'</span> => <span style="color: #ce9178;">'966500000000'</span>, <span style="color: #6a9955;">// رقم المستلم</span>
        <span style="color: #ce9178;">'template_name'</span> => <span style="color: #ce9178;">'order_update'</span>,
        <span style="color: #ce9178;">'language_code'</span> => <span style="color: #ce9178;">'ar'</span>,
        <span style="color: #ce9178;">'components'</span> => [
            [
                <span style="color: #ce9178;">"type"</span> => <span style="color: #ce9178;">"body"</span>,
                <span style="color: #ce9178;">"parameters"</span> => [
                    [<span style="color: #ce9178;">"type"</span> => <span style="color: #ce9178;">"text"</span>, <span style="color: #ce9178;">"text"</span> => <span style="color: #ce9178;">"Ahmed"</span>],      <span style="color: #6a9955;">// {{1}} Customer Name</span>
                    [<span style="color: #ce9178;">"type"</span> => <span style="color: #ce9178;">"text"</span>, <span style="color: #ce9178;">"text"</span> => <span style="color: #ce9178;">"Shipped"</span>]     <span style="color: #6a9955;">// {{2}} Order Status</span>
                ]
            ]
        ]
    ]
]);
</pre>
                </div>

                {{-- Example 3: cURL Text (المصحح) --}}
                <div x-show="tab === 'curl_text'">
                    <div class="mb-2 text-gray-500">// Example: Sending a simple Text Message (Standard)</div>
<pre>
<span style="color: #c586c0;">curl</span> -X POST <span style="color: #ce9178;">"{{ url('/api/v1/send-message') }}"</span> \
-H <span style="color: #ce9178;">"Authorization: Bearer <span style="color: #f1fa8c; font-weight: bold;">YOUR_API_KEY</span>"</span> \
-H <span style="color: #ce9178;">"Content-Type: application/json"</span> \
-d '{
    <span style="color: #9cdcfe;">"to"</span>: <span style="color: #ce9178;">"966500000000"</span>,
    <span style="color: #9cdcfe;">"text_message"</span>: <span style="color: #ce9178;">"Hello world from WhatsMark!"</span> <span style="color: #6a9955;">// محتوى الرسالة النصية</span>
}'
</pre>
                </div>

            </div>
        </div>
    </div>

</x-filament-panels::page>