<x-filament-panels::page>
    <div class="space-y-6">

        {{-- قسم تفاصيل الباقة --}}
        <x-filament::section>
            <x-slot name="heading">
                تفاصيل الباقة الحالية
            </x-slot>

            <div class="grid grid-cols-1 md:grid-cols-2 lg:grid-cols-3 gap-6">
                {{-- اسم الباقة --}}
                <div class="bg-gray-50 dark:bg-gray-800 p-4 rounded-lg shadow-inner">
                    <p class="text-sm font-medium text-gray-500 dark:text-gray-400">اسم الباقة</p>
                    <p class="text-xl font-bold text-primary-600 dark:text-primary-400">
                        {{ $user->package->name ?? 'الباقة الافتراضية' }}
                    </p>
                </div>

                {{-- سعر الباقة --}}
                <div class="bg-gray-50 dark:bg-gray-800 p-4 rounded-lg shadow-inner">
                    <p class="text-sm font-medium text-gray-500 dark:text-gray-400">السعر</p>
                    <p class="text-xl font-bold text-gray-800 dark:text-gray-200">
                        {{ number_format($user->package->price ?? 0) }} ريال
                    </p>
                </div>
                
                {{-- تاريخ انتهاء الاشتراك --}}
                <div class="bg-gray-50 dark:bg-gray-800 p-4 rounded-lg shadow-inner">
                    <p class="text-sm font-medium text-gray-500 dark:text-gray-400">ينتهي في</p>
                    <p class="text-xl font-bold text-gray-800 dark:text-gray-200">
                        @if ($user->subscription_ends_at)
                            {{ $user->subscription_ends_at->format('Y-m-d') }}
                        @else
                            غير محدد
                        @endif
                    </p>
                </div>
            </div>
        </x-filament::section>

        {{-- قسم أشرطة الاستهلاك --}}
        <x-filament::section>
            <x-slot name="heading">
                متابعة الاستهلاك
            </x-slot>
            
            <div class="grid grid-cols-1 md:grid-cols-2 lg:grid-cols-3 gap-4">
                
                @foreach($usage as $key => $data)
                    
                    {{-- 🔑 المنطق المُصحح: عرض أشرطة التقدم للعناصر التي لديها حد واستهلاك --}}
                    @if (isset($data['limit']) && isset($data['used']))
                        @php
                            $limit = $data['limit'];
                            $used = $data['used'];
                            
                            // حساب النسبة المئوية
                            $percentage = ($limit > 0) ? min(100, round(($used / $limit) * 100)) : 0;
                            
                            // تحديد اللون بناءً على النسبة
                            $color = $percentage > 90 ? 'bg-red-500' : ($percentage > 70 ? 'bg-yellow-500' : 'bg-primary-500');
                            $colorHex = $percentage > 90 ? '#ef4444' : ($percentage > 70 ? '#f59e0b' : '#3b82f6'); // ألوان CSS
                        @endphp
                        
                        {{-- كارت الاستهلاك بنظام العداد --}}
                        <div class="bg-white p-4 rounded-lg border shadow-sm dark:bg-gray-800 dark:border-gray-700">
                            <div class="flex justify-between mb-2">
                                <span class="text-sm font-medium text-gray-700 dark:text-gray-200">{{ $data['label'] }}</span>
                                <span class="text-sm font-medium text-gray-700 dark:text-gray-200">
                                    {{ $used }} / {{ ($limit > 0) ? $limit : 'غير محدود' }}
                                </span>
                            </div>

                            {{-- شريط التقدم --}}
                            <div class="w-full bg-gray-200 rounded-full h-2.5 dark:bg-gray-700">
                                <div class="h-2.5 rounded-full" style="width: {{ $percentage }}%; background-color: {{ $colorHex }};"></div>
                            </div>
                            <p class="mt-1 text-xs text-gray-500 dark:text-gray-400">{{ $percentage }}% مستهلك</p>
                        </div>

                    {{-- 🔑 المنطق المُصحح: عرض الرصيد المتبقي كرقم كبير (بدون شريط تقدم) --}}
                    @elseif (isset($data['current']))
                        {{-- كارت عرض الرصيد الحالي --}}
                        <div class="bg-white p-4 rounded-lg border shadow-sm dark:bg-gray-800 dark:border-gray-700">
                            <div class="flex justify-between mb-1">
                                <span class="text-sm font-medium text-gray-500 dark:text-gray-400">{{ $data['label'] }}</span>
                            </div>
                            <p class="text-3xl font-extrabold text-primary-600 dark:text-primary-400">
                                {{ number_format($data['current']) }}
                            </p>
                            <p class="mt-1 text-xs text-gray-500 dark:text-gray-400">هذا هو رصيدك المتبقي للإرسال الفوري.</p>
                        </div>
                    @endif
                @endforeach
            </div>
        </x-filament::section>
        
        {{-- قسم الرسائل الأخرى (مثل الحد الأقصى الشهري إذا كان موجودًا) --}}
        @if (isset($usage['package_messages_limit']))
            <x-filament::section>
                <x-slot name="heading">
                    حدود الرسائل
                </x-slot>
                
                <p class="text-gray-700 dark:text-gray-300">
                    حد رسائل الباقة ({{ $usage['package_messages_limit']['label'] ?? 'إجمالي' }}): 
                    <span class="font-bold text-lg text-primary-600 dark:text-primary-400">
                        {{ number_format($usage['package_messages_limit']['limit'] ?? 0) }} رسالة
                    </span>
                </p>
                <p class="mt-2 text-sm text-gray-500 dark:text-gray-400">
                    *هذا الحد يمثل السقف الأعلى الذي يمكن شحنه لك في فترة الباقة.
                </p>
            </x-filament::section>
        @endif

        
    </div>
</x-filament-panels::page>