<!DOCTYPE html>
<html lang="ar" dir="rtl" x-data="{ darkMode: false }" :class="{'dark': darkMode}">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>{{ $settings->hero_title_ar ?? 'نظام إرسال الواتساب الاحترافي' }}</title>
    
    <link href="https://cdn.jsdelivr.net/npm/tailwindcss@2.2.19/dist/tailwind.min.css" rel="stylesheet"> 
    <link href="https://unpkg.com/aos@2.3.1/dist/aos.css" rel="stylesheet">
    
    {{-- 🔑 خط عربي احترافي (مثال: Cairo أو Tajawal) --}}
    <link href="https://fonts.googleapis.com/css2?family=Tajawal:wght@400;700;900&display=swap" rel="stylesheet">
    
    <style>
        :root {
            --primary-color: #3b82f6; 
            --primary-dark: #1f2937;
        }
        body { font-family: 'Tajawal', sans-serif; }
        .primary-text { color: var(--primary-color); }
        .cta-btn { background-color: var(--primary-color); color: white; transition: all 0.3s; }
        .cta-btn:hover { background-color: #2563eb; transform: translateY(-2px); }
        
        /* 🔑 تنسيقات الوضع الليلي (Tailwind يكفل الباقي باستخدام dark:) */
        .dark .primary-bg { background-color: #111827; }
        .dark body { background-color: #111827; color: #d1d5db; }
    </style>
    {{-- 🔑 سكريبت Alpine.js لدعم الـ Dark Mode الديناميكي --}}
    <script src="https://cdn.jsdelivr.net/gh/alpinejs/alpine@v3.x/dist/cdn.min.js" defer></script> 
</head>
<body class="bg-gray-50 text-gray-800 transition duration-500">
    
    @include('landing.header')

    @include('landing.hero', ['settings' => $settings])
    @include('landing.features', ['settings' => $settings])
    @include('landing.pricing', ['plans' => $plans])
    @include('landing.faq', ['settings' => $settings])
    @include('landing.final-cta')
    
    @include('landing.footer')
    
    <script src="https://unpkg.com/aos@2.3.1/dist/aos.js"></script>
    <script> AOS.init({ duration: 800, once: true, }); </script>
</body>
</html>