<section class="py-20 bg-white">
    <div class="max-w-4xl mx-auto px-4 sm:px-6 lg:px-8 text-center">
        <h2 class="text-4xl font-extrabold text-gray-900 mb-12">أسئلة شائعة وإجابات واضحة</h2>
        
        <div class="space-y-4 text-right">
            @foreach ($settings->faq ?? [] as $item)
                <div class="border border-gray-200 rounded-lg overflow-hidden shadow-md" data-aos="fade-up">
                    {{-- استخدام <details> لتحقيق تأثير الأكورديون الأساسي بدون JS --}}
                    <details class="group">
                        <summary class="flex justify-between items-center p-5 cursor-pointer bg-gray-50 hover:bg-gray-100 transition duration-300">
                            <h3 class="text-lg font-semibold text-gray-900">{{ $item['question_ar'] }}</h3>
                            <svg class="w-6 h-6 transform transition-transform duration-300 group-open:rotate-180 text-gray-600" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                                <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M19 9l-7 7-7-7"></path>
                            </svg>
                        </summary>
                        <div class="px-5 py-4 bg-white text-gray-600 border-t border-gray-200 text-right">
                            <p>{{ $item['answer_ar'] }}</p>
                        </div>
                    </details>
                </div>
            @endforeach
        </div>
    </div>
</section>