<footer class="py-12 border-t border-gray-200 dark:border-gray-800 bg-white dark:bg-gray-900 transition duration-500">
    <div class="max-w-7xl mx-auto px-4 sm:px-6 lg:px-8">
        <div class="grid grid-cols-2 md:grid-cols-5 gap-8 text-right">
            
            {{-- 1. معلومات الشركة والشعار --}}
            <div class="col-span-2 md:col-span-2">
                <a href="{{ route('landing') }}" class="flex items-center space-x-2 space-x-reverse mb-4">
                    <svg class="w-8 h-8 primary-text" fill="none" stroke="currentColor" viewBox="0 0 24 24" xmlns="http://www.w3.org/2000/svg"><path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M8 12h.01M12 12h.01M16 12h.01M21 12a9 9 0 11-18 0 9 9 0 0118 0z"></path></svg>
                    <span class="text-2xl font-extrabold text-gray-900 dark:text-white">WhatsMark</span>
                </a>
                <p class="text-sm text-gray-500 dark:text-gray-400">
                    نظام التسويق الأقوى عبر واتساب. أطلق حملاتك وراقب أدائك بكفاءة.
                </p>
                <div class="mt-4 flex space-x-4 space-x-reverse">
                    {{-- 🔑 روابط التواصل الاجتماعي (يمكن تخصيصها من لوحة التحكم لاحقاً) --}}
                    <a href="#" class="text-gray-400 hover:text-blue-500 transition duration-300">
                        <svg class="w-6 h-6" fill="currentColor" viewBox="0 0 24 24" xmlns="http://www.w3.org/2000/svg"><path d="M14 13.5h2.5L17 9h-3v-2c0-1.03 0-2 .234-2.253C14.469 4.5 15 4.5 16 4.5h2V2h-3C11.5 2 10 3.5 10 7v2H7v4.5h3v7.5h4v-7.5z"/></svg>
                    </a>
                </div>
            </div>

            {{-- 2. روابط سريعة --}}
            <div>
                <h4 class="text-lg font-bold text-gray-900 dark:text-white mb-4">روابط سريعة</h4>
                <ul class="space-y-3 text-sm">
                    <li><a href="{{ route('landing') }}" class="text-gray-500 dark:text-gray-400 hover:primary-text transition duration-300">الرئيسية</a></li>
                    <li><a href="#pricing" class="text-gray-500 dark:text-gray-400 hover:primary-text transition duration-300">الأسعار</a></li>
                    <li><a href="#features" class="text-gray-500 dark:text-gray-400 hover:primary-text transition duration-300">الميزات</a></li>
                </ul>
            </div>

            {{-- 3. الدعم القانوني --}}
            <div>
                <h4 class="text-lg font-bold text-gray-900 dark:text-white mb-4">الدعم</h4>
                <ul class="space-y-3 text-sm">
                    <li><a href="#" class="text-gray-500 dark:text-gray-400 hover:primary-text transition duration-300">شروط الخدمة</a></li>
                    <li><a href="#" class="text-gray-500 dark:text-gray-400 hover:primary-text transition duration-300">سياسة الخصوصية</a></li>
                    <li><a href="#faq" class="text-gray-500 dark:text-gray-400 hover:primary-text transition duration-300">الأسئلة الشائعة</a></li>
                </ul>
            </div>
            
            {{-- 4. التواصل --}}
            <div>
                <h4 class="text-lg font-bold text-gray-900 dark:text-white mb-4">تواصل معنا</h4>
                <ul class="space-y-3 text-sm text-gray-500 dark:text-gray-400">
                    <li>info@whatsmark.com</li>
                    <li>+966 50 XXX XXXX</li>
                </ul>
            </div>
        </div>

        <div class="mt-12 pt-6 border-t border-gray-200 dark:border-gray-800 text-center">
            <p class="text-sm text-gray-500 dark:text-gray-400">
                &copy; {{ date('Y') }} WhatsMark. جميع الحقوق محفوظة.
            </p>
        </div>
    </div>
</footer>