{{-- 
    ======================================
    1. شاشة البداية (HERO SECTION)
    ======================================
    المتغيرات المستخدمة:
    - $settings: كائن LandingPageSetting
--}}
<section class="primary-bg py-24 md:py-32 text-center text-white relative overflow-hidden">
    {{-- إضافة تأثير بصري خفيف (كروي) --}}
    <div class="absolute inset-0 bg-repeat bg-center opacity-10" style="background-image: url('data:image/svg+xml;utf8,<svg viewBox=\'0 0 100 100\' xmlns=\'http://www.w3.org/2000/svg\'><circle cx=\'50\' cy=\'50\' r=\'1\' fill=\'#4a5568\'/></svg>');"></div>

    <div class="max-w-7xl mx-auto px-4 sm:px-6 lg:px-8 relative z-10">
        <div class="md:grid md:grid-cols-2 md:gap-12 items-center text-right">
            
            {{-- 1. المحتوى النصي والدعوة للإجراء (CTA) --}}
            <div class="order-1 mt-12 md:mt-0" data-aos="fade-right">
                <h1 class="text-5xl md:text-6xl font-extrabold leading-tight primary-text mb-4">
                    {{ $settings->hero_title_ar }}
                </h1>
                <p class="text-xl text-gray-300 mb-8">
                    {{ $settings->hero_subtitle_ar }}
                </p>
                <a href="{{ route('register') }}" class="cta-btn py-3 px-8 text-lg font-bold rounded-full shadow-lg hover:shadow-xl inline-block">
                    {{ $settings->hero_cta_text_ar }}
                </a>
            </div>

            {{-- 2. الوسائط (صورة/فيديو) --}}
            <div class="order-2 mt-12 md:mt-0 md:text-left" data-aos="fade-left">
                @if ($settings->hero_image_url)
                    @php
                        // جلب الرابط العام للملف المرفوع
                        $imageUrl = Storage::url($settings->hero_image_url);
                        // تحديد ما إذا كان الملف صورة أو فيديو (بناءً على الامتداد)
                        $is_video = in_array(pathinfo($imageUrl, PATHINFO_EXTENSION), ['mp4', 'mov', 'webm']);
                    @endphp
                    
                    @if ($is_video)
                        {{-- عرض الفيديو مع تشغيل تلقائي ومستمر --}}
                        <video 
                            src="{{ $imageUrl }}" 
                            autoplay 
                            loop 
                            muted 
                            playsinline
                            class="mx-auto rounded-xl shadow-2xl w-full max-w-md transform hover:scale-105 transition duration-500 border border-gray-700"
                        >
                            متصفحك لا يدعم عرض الفيديو.
                        </video>
                    @else
                        {{-- عرض الصورة --}}
                        <img 
                            src="{{ $imageUrl }}" 
                            alt="{{ $settings->hero_title_ar }}" 
                            class="mx-auto rounded-xl shadow-2xl w-full max-w-md transform hover:scale-105 transition duration-500 border border-gray-700"
                        >
                    @endif
                @else
                    {{-- صورة افتراضية أو تصميم Mockup لـ UI --}}
                    
                    <div class="p-8 bg-gray-700 rounded-xl max-w-md mx-auto shadow-2xl">
                        <p class="text-gray-300">يجب عليك رفع صورة أو فيديو من لوحة التحكم لتظهر هنا.</p>
                    </div>
                @endif
            </div>

        </div>
    </div>
</section>