{{-- 
    ======================================
    3. قسم الخطط والتسعير (PRICING PLANS)
    ======================================
    المتغيرات المستخدمة:
    - $plans: مجموعة من كائنات Plan
--}}
<section class="primary-bg py-20 text-white">
    <div class="max-w-7xl mx-auto px-4 sm:px-6 lg:px-8 text-center">
        <h2 class="text-4xl font-extrabold text-white mb-12" data-aos="fade-up">خطط تسعير تناسب نموك</h2>
        
        <div class="grid grid-cols-1 md:grid-cols-3 gap-8">
            @forelse ($plans as $plan)
                <div 
                    class="bg-white text-gray-900 p-8 rounded-xl shadow-2xl relative transition duration-500 {{ $plan->is_recommended ? 'border-4 border-yellow-400 transform scale-105' : '' }}" 
                    data-aos="fade-up" 
                    data-aos-delay="{{ ($loop->index + 1) * 200 }}"
                >
                    
                    @if ($plan->is_recommended)
                        <span class="absolute top-0 right-0 bg-yellow-400 text-sm font-bold py-1 px-3 rounded-bl-lg">
                            الباقة الموصى بها
                        </span>
                    @endif

                    <h3 class="text-2xl font-bold mb-4 primary-text">{{ $plan->name_ar }}</h3>
                    <p class="text-5xl font-extrabold mb-6 text-gray-900">
                        {{ number_format($plan->price, 0) }} ر.س
                        <span class="text-base font-normal text-gray-500">/ شهرياً</span>
                    </p>
                    
                    <ul class="text-right space-y-4 mb-8">
                        {{-- معلومات الباقة الأساسية --}}
                        <li class="flex items-center justify-end">
                            <span class="font-semibold">{{ $plan->max_whatsapp_accounts }} حساب واتساب</span>
                            <svg class="h-5 w-5 text-green-500 mr-2" fill="none" stroke="currentColor" viewBox="0 0 24 24"><path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M5 13l4 4L19 7"></path></svg>
                        </li>
                        <li class="flex items-center justify-end">
                            <span class="font-semibold">{{ $plan->monthly_credits }} رسالة شهرية</span>
                            <svg class="h-5 w-5 text-green-500 mr-2" fill="none" stroke="currentColor" viewBox="0 0 24 24"><path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M5 13l4 4L19 7"></path></svg>
                        </li>
                        
                        {{-- الميزات الديناميكية من Repeater --}}
                        @foreach ($plan->features_ar as $feature)
                            <li class="flex items-center justify-end text-gray-600">
                                <span>{{ $feature['feature'] }}</span>
                                <svg class="h-5 w-5 text-green-500 mr-2" fill="none" stroke="currentColor" viewBox="0 0 24 24"><path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M5 13l4 4L19 7"></path></svg>
                            </li>
                        @endforeach
                    </ul>
                    
                    <a href="{{ route('register') }}" class="cta-btn w-full block py-3 rounded-lg font-bold text-lg hover:bg-blue-600">
                        ابدأ بباقة {{ $plan->name_ar }}
                    </a>
                </div>
            @empty
                <div class="col-span-3 text-center text-gray-300 p-8 border border-dashed border-gray-600 rounded-lg">
                    <p>الرجاء إضافة باقات التسعير من <a href="{{ route('filament.admin.resources.plans.index') }}" class="primary-text font-bold hover:underline">لوحة التحكم</a> لتظهر هنا.</p>
                </div>
            @endforelse
        </div>
    </div>
</section>