<?php

use Illuminate\Support\Facades\Route;
use Illuminate\Http\Request; // 🔑 تم استيراد Request للتعامل مع Route::get('/v1/user')
// use App\Models\User; // ❌ غير مستخدم بعد حذف مسار generate-token
// use Illuminate\Support\Facades\Hash; // ❌ غير مستخدم بعد حذف مسار generate-token
use App\Http\Controllers\API\WhatsAppWebhookController;
use App\Http\Controllers\API\ExternalSendController;
use App\Http\Controllers\WebhookController;

// ------------------------------------------------------------------
// 1. مسارات الويب هوك العامة (Webhook Routes)
//    (لا تتطلب مصادقة Bearer Token)
// ------------------------------------------------------------------

// 🔑 مسار التحقق من الويب هوك (GET) ومسار استقبال الرسائل الواردة (POST)
// المسار: /api/cloud-webhook
Route::any('cloud-webhook', [WhatsAppWebhookController::class, 'handleWebhook'])->name('whatsapp.cloud.webhook');


// 🔑 مسار الويب هوك الخاص بمنطق الشات بوت والمكونات المخصصة
// المسار: /api/chatbot-webhook
Route::post('chatbot-webhook', [WebhookController::class, 'handleIncomingMessage'])->name('whatsapp.chatbot.webhook');


// ------------------------------------------------------------------
// 2. مسارات API الموثقة (Authenticated API)
//    (تتطلب Bearer Token للمصادقة عبر Sanctum)
// ------------------------------------------------------------------


Route::middleware(['auth:sanctum'])->group(function () {
    
    // مسار التحقق البسيط (اختبار للتأكد من نجاح المصادقة)
    Route::get('/v1/user', function (Request $request) {
        // إذا وصلت إلى هنا، فالمصادقة نجحت وستعود بيانات المستخدم كـ JSON
        return $request->user();
    });
    
    // مسار إرسال الرسالة (الذي يسبب المشكلة)
    Route::post('/v1/send-message', [ExternalSendController::class, 'send']);
});

// ❌ تم حذف مسار /v1/generate-token نظراً لأن المستخدمين يولدون الـ Token من لوحة التحكم